$explodeSmallAudioCount = 1;
$explodeMediumAudioCount = 4;
$explodeLargeAudioCount = 3;
$chainSelectAudioCount = 4;
$breakAudioCount = 6;
$announcerAudioCount = 4;

new AudioDescription(AudioLooping)
{
	volume = 1.0;
	isLooping= true;
	is3D = false;
	type = 1;
};

new AudioDescription(AudioSFX)
{
	volume = 1.0;
	isLooping= false;
	is3D = false;
	type = 2;
};

new AudioDescription(AudioExplosion)
{
	volume = 1.0;
	isLooping= false;
	is3D = true;
	type = 8;
};
new AudioDescription(AudioBreak)
{
	volume = 0.9;
	isLooping= false;
	is3D = true;
	type = 7;
};

//new AudioProfile(menuMusic)
//{
//	filename = "game/data/audio/music/menu.ogg";
//	description = "AudioLooping";
//	preload = true;
//};


new AudioProfile(gameMusic)
{
	filename = "game/data/audio/music/menu.ogg";
	description = "AudioLooping";
	preload = true;
};


new AudioProfile(levelStart)
{
	filename = "game/data/audio/sfx/levelStart.wav";
	description = "AudioSFX";
	preload = true;
};

new AudioProfile(flawlessVictory)
{
	filename = "game/data/audio/announcer/flawlessVictory.wav";
	description = "AudioSFX";
	preload = true;
};

new AudioProfile(buttonDown)
{
	filename = "game/data/audio/sfx/buttonSelect.wav";
	description = "AudioSFX";
	preload = true;
};

function setUpSounds()
{
	echo("--Initializing sounds--");
	
	%name = "smallExplode";
	for(%i = 1; %i <= $explodeSmallAudioCount; %i++)
	{
		new AudioProfile(%name @ %i)
		{
			filename = "game/data/audio/explosions/" @ %name @ %i @ ".wav";
			description = "AudioExplosion";
			preload = true;
		};
	}
	
	%name = "mediumExplode";
	for(%i = 1; %i <= $explodeMediumAudioCount; %i++)
	{
		new AudioProfile(%name @ %i)
		{
			filename = "game/data/audio/explosions/" @ %name @ %i @ ".wav";
			description = "AudioExplosion";
			preload = true;
		};
	}
	
	%name = "largeExplode";
	for(%i = 1; %i <= $explodeLargeAudioCount; %i++)
	{
		new AudioProfile(%name @ %i)
		{
			filename = "game/data/audio/explosions/" @ %name @ %i @ ".wav";
			description = "AudioExplosion";
			preload = true;
		};
	}
	
	%name = "chainSelect";
	for(%i = 1; %i <= $chainSelectAudioCount; %i++)
	{
		new AudioProfile(%name @ %i)
		{
			filename = "game/data/audio/sfx/" @ %name @ %i @ ".wav";
			description = "AudioSFX";
			preload = true;
		};
	}
	
	%name = "break";
	for(%i = 1; %i <= $breakAudioCount; %i++)
	{
		new AudioProfile(%name @ %i)
		{
			filename = "game/data/audio/break/" @ %name @ %i @ ".wav";
			description = "AudioBreak";
			preload = true;
		};
	}
	
	%name = "announcer";
	for(%i = 1; %i <= $announcerAudioCount; %i++)
	{
		new AudioProfile(%name @ %i)
		{
			filename = "game/data/audio/announcer/" @ %name @ %i @ ".wav";
			description = "AudioSFX";
			preload = true;
		};
	}
	
	echo("--Finished initializing sounds--");
}

setUpSounds();